import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/home/home_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_close_button.dart';
import 'package:viserpay_agent/view/components/divider/custom_divider.dart';
import 'package:viserpay_agent/view/components/text/bottom_sheet_header_text.dart';

class MainItemBottomSheet {
  static void mainItemBottomSheet(BuildContext context) {
    showModalBottomSheet(
      isScrollControlled: true,
      backgroundColor: MyColor.getTransparentColor(),
      context: context,
      builder: (context) => GetBuilder<HomeController>(
          builder: (controller) => SingleChildScrollView(
            physics: const ClampingScrollPhysics(),
            child: Container(
              width: MediaQuery.of(context).size.width,
              padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space15),
              decoration: BoxDecoration(color: MyColor.getCardBgColor(), borderRadius: const BorderRadius.vertical(top: Radius.circular(20))),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [BottomSheetHeaderText(text: MyStrings.moreOptions), BottomSheetCloseButton()],
                  ),
                  const CustomDivider(space: Dimensions.space15),
                  Wrap(
                    spacing: 8.0,
                    runSpacing: 8.0,
                    children: [
                      ...controller.bottomSheetModuleList
                        .getRange(0, controller.bottomSheetModuleList.length)
                        .map((item) => SizedBox(
                              width: (MediaQuery.of(context).size.width - 32 - 24) / 4,
                              child: item,
                            ))
                        ,
                    ],
                  )
                ],
              ),
            ),
          )));
  }
}
